package edu.minilive.wedu.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import edu.minilive.wedu.entity.App;
import edu.minilive.wedu.entity.CompanyApp;


/**
 * <b>单位应用</b> 服务层接口定义
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-2-25 上午11:21:10
 */
@Transactional
public interface CompanyAppService {
	/**
	 * 添加应用
	 * @param companyApp
	 * @return
	 */
	CompanyApp createCompanyApp(CompanyApp companyApp);
	
	/**
	 * 根据Id查询机构应用(不带缓存）
	 * @param id
	 * @return
	 */
	CompanyApp getCompanyAppById(Long id);
	
	/**
	 * 更新应用
	 * @param companyApp
	 */
	void updateCompanyApp(CompanyApp companyApp);
	
	/**
	 * 综合查询学校所有APP
	 * @param school		*学校
	 * @param apptype		应用类型(-1不为条件,1-微博应用[适用于全校用户],2-OA应用[适用于教师用户)
	 * @param appalias		应用别名(示：WeiPhoto，WeiVideo...)
	 * @param app			应用实体
	 * @param state			应用状态(-1不为条件,1-启动,2-禁用)
	 * @return
	 */
	List<CompanyApp> getCompanyAppList(Long schoolId,String appalias, App app,  int apptype, int state, int showApp);
	
	/**
	 * 查询校园微信应用（带缓存）
	 * @param school	学校编号
	 * @return
	 */
	List<CompanyApp> getCompanyAppList(Long school);
	
	/**
	 * 清除校园微信应用缓存
	 * @param schoolId
	 */
	void clearCompanyAppListCache(Long school);
	
	/**
	 * 查询学校所有APP
	 * @param school		*学校
	 * @param appalias		应用别名(示：WeiPhoto，WeiVideo...)
	 * @return
	 */
	CompanyApp getCompanyApp(Long schoolId,String appalias);
	
	
}
