package edu.minilive.wedu.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.entity.Channel;
import edu.minilive.wedu.entity.Company;


/**
 * <b>栏目</b> 服务层接口定义
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-2 上午11:30:06
 */
@Transactional
public interface ChannelService {
	/**
	 * 保存新栏目
	 * @param post
	 * @return
	 */
	Channel addChannel(Channel post);
	
	/**
	 * 根据频道ID读取频道实体
	 * @param id
	 * @return
	 */
	Channel getChannel(Long id);
	
	/**
	 * 根据频道ID读取频道实体（带缓存）
	 * <li>附带子栏目列表
	 * @param id
	 * @return
	 */
	Channel getChannelById(Long id);
	
	/**
	 * 根据频道别名读取实体
	 * @param alias
	 * @return
	 */
	Channel getChannelByAlias(String alias);
	
	/**
	 * 更新频道并清除频道缓存
	 * @param channel
	 * @return
	 */
	Channel updateChannel(Channel channel);
	
	/**
	 * 根据父频道查询子频道列表
	 * @param channel
	 * @return
	 */
	List<Channel> getChannelListByParent(Channel channel);
	/**
	 * 清除getChannelListByParent缓存
	 * @param channel
	 */
	void clearChannelListByParentCache(Channel channel);
	
	/**
	 * 读取一级栏目
	 * @return
	 */
	List<Channel> getChannelList();
	
	/**
	 * 读取学校、单位栏目列表
	 * @param company		单位实体
	 * @param parentChannel	父频道（NULL时读取顶级栏目）
	 * @param page			分页（NULL，读取所有）
	 * @return
	 */
	List<Channel> getChannelByCompany(Company company, Channel parentChannel, Page page);
	
	
	/**
	 * 读取机构顶级栏目列表(带缓存）
	 * <li>并遍历好所有子目录
	 * @param company
	 * @return
	 */
	List<Channel> getAllChannelByCompany(Company company);
	/**
	 * 清除机构所有栏目列表缓存
	 * @param schoolId
	 */
	void clearAllChannelByCompanyCache(Long schoolId);
}
