package edu.minilive.wedu.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.entity.Article;
import edu.minilive.wedu.entity.User;

/**
 * <b>文章</b> 服务层接口定义
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-2 上午11:30:06
 */
@Transactional
public interface ArticleService {
	/**
	 * 新增文章
	 * @param article
	 * @return
	 */
	Article addArticle(Article article);
	
	
	
	/**
	 * 根据ID读取（带缓存）
	 * @param id
	 * @return
	 */
	Article getArticleById(Long id);
	
	/**
	 * 更新文章内容
	 * @param article
	 * @return
	 */
	Article updateArticle(Article article);
	
	
	
	/**
	 * 查询单位文章列表【单位后台】
	 * @param company		单位（不能为NULL）
	 * @param keyword		关键词
	 * @param channel		所属栏目
	 * @param page			分页（NULL读取所有）
	 * @return
	 */
	List<Article> getArticleListByCompany(Long companyId, String keyword, Long channelId, Page page);
	
	
	
	
	
	/**
	 * 读取栏目列表
	 * @param channelId		栏目ID（-1或者NULL不为条件）
	 * @param page
	 * @return
	 */
	List<Article> getChannelList(Long channelId,Page page);
	
	
	/**
	 * 根据作者读取列表
	 * @param user
	 * @param page
	 * @return
	 */
	List<Article> getArticleByUser(User user, Page page);
	
	
	/**
	 * 根据关键词查询文章列表
	 * @param keyword
	 * @param page
	 * @return
	 */
	List<Article> getArticleByKeyword(String keyword, Page page);
	
	/**
	 * 根据标签查询文章列表
	 * @param keyword
	 * @param page
	 * @return
	 */
	List<Article> getArticleByTag(String tag, Page page);
}
