package edu.minilive.wedu.entity.app;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

/**
 * 过去与现在【微应用】
 * 照片（ID、过去照、现在照、标题、描述、用户、创建时间）
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-9-29 下午1:51:58
 */
@Entity
@Table(name = "TAB_WPP_FORMERNOW")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class WppFormerNow {
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	/**
	 * 标题
	 */
	private String title;
	/**
	 * 描述
	 */
	private String description;
	/**
	 * 过去照
	 */
	private String formerUrl;
	/**
	 * 现在照
	 */
	private String nowUrl;
	
	/** 创建日期 (排序)**/
	private Date createDate;
	
	/**
	 * 所属用户编号
	 */
	private Long userId;
}
