package edu.minilive.wedu.entity.app;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

/**
 * 微喜帖-祝福
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-17 下午2:52:19
 */
@Entity
@Table(name = "TAB_APP_WEIXITIE_BLESSING")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class WeiXiTieBlessing  {
	
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/**
	 * 发起祝福人
	 */
	private String name;
	
	/**
	 * 祝福
	 */
	private String content;
	
	/** 祝福时间 **/
	private Date createDate;
	
	/**
	 * 所属喜帖
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="weixitie_id")
	private WeiXiTie weixitie;
}
