package edu.minilive.wedu.entity.app;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

/**
 * [微投票]投票记录
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-10-27 上午10:29:14
 */
@Entity
@Table(name = "TAB_APP_WEIVOTEITEMREC")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class WeiVoteItemRec {
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/**
	 * 微投票编号
	 * WeiVote.id
	 */
	private Long voteId;
	
	/**
	 * 微投票项编号
	 * WeiVoteItem.id
	 */
	private Long voteItemId;
	
	/**
	 * 投票者
	 * user.id
	 */
	private Long userId;
	
	/**
	 * 所属微信号
	 */
	private String openId;
	
	/**
	 * IP地址
	 */
	private String ip;
	
	/**
	 * 投票时间
	 */
	private Date createDate;
}
