package edu.minilive.wedu.entity.app;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import edu.ecompus.core.util.HttpUtil;

/**
 * [微投票]投票项
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-10-27 上午10:21:41
 */
@Entity
@Table(name = "TAB_APP_WEIVOTEITEM")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class WeiVoteItem {
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/**
	 * 投票项名
	 */
	private String title;
	
	/**
	 * 投票项描述
	 */
	private String content;
	
	/**
	 * 投票数
	 */
	private Long vcount;
	
	/**
	 * 微投票编号
	 * WeiVote.id
	 */
	private Long voteId;
	
	
	/**排序**/
	private int orderNo = 1;
	
	/**
	 * 状态，0-未发布，1——正常，2——删除
	 */
	private int state = 0;
	
	/**
	 * 获取文章图片链接地址
	 * @return
	 */
	@Transient
	public String getTextImg()
	{
		if(content!=null && !"".equals(content)){
			String img="";        
	        Pattern p_image;        
	        Matcher m_image;        
	       
	        String regEx_img = "<img.*src=(.*?)[^>]*?>"; //图片链接地址        
	        p_image = Pattern.compile(regEx_img,Pattern.CASE_INSENSITIVE);
	        
	        m_image = p_image.matcher(HttpUtil.encodeHtml(content));  
	        while(m_image.find()){ 
	        	img = img + "," + m_image.group();
	        	Matcher m  = Pattern.compile("src=\"?(.*?)(\"|>|\\s+)").matcher(img); //匹配src     
	            while(m.find()){
	            	String url = m.group(1);
	            	url = url.replace("'", "");
	               return url;     
	            } 
	        }
		}
		
		return "";
	}
}
