package edu.minilive.wedu.entity.app;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

/**
 * 微投票
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-10-27 上午10:07:32
 */
@Entity
@Table(name = "TAB_APP_WEIVOTE")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class WeiVote {
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/**
	 * 投票名
	 */
	private String title;
	
	/**
	 * 投票类型
	 * 1-text	文本
	 * 2-img 	图片
	 */
	private int type = 1;
	
	/**
	 * 投票图
	 */
	private String picurl;
	
	/**
	 * 是否显示投票图
	 * 1	显示
	 * 2 	不显示
	 */
	private int showpic = 1;
	
	/**
	 * 投票描述
	 */
	private String content;
	
	/**
	 * 开始时间
	 * （投票条件）
	 */
	private Date sdate;
	
	/**
	 * 结束时间
	 * （投票条件）
	 */
	private Date edate;
	
	/**
	 * 创建时间
	 */
	private Date createDate;
	
	/**
	 * 投票项
	 * 1-单选
	 * 2-多选
	 */
	private int cknums = 1;
	
	/**
	 * 状态，1——正常，2——删除
	 */
	private int state = 1;
	
	
	/**
	 * 所属微信号
	 */
	private String openId;
	
	/**
	 * 个人用户
	 * user.id
	 */
	private Long userId;
	
	/**
	 * 所属学校编号
	 * user.id
	 */
	private Long schoolId;
	
	/**
	 * 所属学校应用编号
	 */
	private Long schoolAppId;
}
