package edu.minilive.wedu.entity.app;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import edu.minilive.wedu.entity.Company;

/**
 * 教育微频设置表
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-6-13 下午2:06:17
 */
@Entity
@Table(name = "TAB_APP_WEIVIDEO_CONFIG")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class WeiVideoConfig {
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	private String mbpos = "RD";			// 放置位置，默认"RD"    "RD"/"LD"/"RT"/"LT"/EMBED
	private int volume = 80;				// 音量 0-静音
	private int autoplay = 0;		// 自动播放1-开启，0-关闭
	private Date createDate;		// 创建时间
	//====当mbpos=EMBED(内嵌)时,以下参数生效
	private String skin = "";			// 皮肤
	private String divId = "";			//	内嵌Div名称
	private int divW = 0;				//内嵌Div宽度,默认300
	private int divH = 0;				//内嵌Div高度,默认254
	
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="company_id")
	private Company company; // 视频属于哪个单位
}
