package edu.minilive.wedu.entity.app;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.User;

import lombok.Data;

/**
 * 教育微频（前教育宽频）
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-6-13 下午2:06:17
 */
@Entity
@Table(name = "TAB_APP_WEIVIDEO")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class WeiVideo {
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	private String title; // 视频标题
	private String watchingTitle;	//看点
	private int subject = 0;// 视频类型（com.eduvideo.common.bean.SubjectList）
	//9000-新闻类,9001-课程类,9002-娱乐类,9003-活动类,9004-课外类,9005-节目类,9006-宣传片
	private Long fileSize;	//文件大小
	private Long duration;	//播放时长
	
	private String introduction; // 视频简介
	
	private String imagePath; // 视频图片路径
	private String videoPath; // 视频路径
	private String sourcePath; // 视频源文件(保存原始视频路径用于转换，万一转换失败，可通过此字段找回当时上传的文件并分析)
	
	private String source;// 视频来源
	private long click = 0l;// 点击量
	
	//======状态  START=======
	//流程：新上传（状态：0），进入转换队列，进入转换（状态4-），转换结束（状态：3-等待审核），审核通过（状态1正常）
	//转换失败40，截图失败41，源文件不存在43
	//正在审核30,审核失败31
	private int status = 0;// 视频状态1-正常 2-注销 
	//======状态   END=======
	
	private int itop = 0;// 视频是否置顶 1-是，0-否
		
	private Date createDate; // 上传日期
	//
	
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="user_id")
	private User user; // 视频上传者（用户）
	
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="company_id")
	private Company company; // 视频属于哪个单位
}
