package edu.minilive.wedu.entity.app;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import edu.minilive.wedu.entity.Company;


/**
 * 
 * 模块表（微应用）
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-6-25 下午4:41:05
 */
@Entity
@Table(name = "TAB_WEIAPP")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class WeiApp {
	
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/**
     * 模块名称       db_column: name  例如:日志,视频,相册,文章,校务OA 
     */ 	
	private String name;
	
	/**
	 * 模块别名
	 */
	private String alias;
	
	/**
	 * 模块资源	 db_column: url		例如:**\/teacher/** 
	 */
	private String resurl;
	
	/**
	 * 描述	 
	 */
	private String content;
	
	/**
	 * 状态  例如:1-正常    2-注销
	 */
	private int state = 1;
	
	
	/** 创建日期 (排序)**/
	private Date createDate;
	
	/**
	 * 所属单位
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="company_id")
	private Company company;

}
