package edu.minilive.wedu.entity.app;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.CompanyApp;
import edu.minilive.wedu.entity.User;

/**
 * 微相册
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-6-2 上午10:21:31
 */
@Entity
@Table(name = "TAB_APP_WEIALBUM")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class WeiAlbum {
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/**
	 * 相册
	 */
	private String title;
	
	/**
	 * 状态，1——正常，2——删除
	 */
	private int state = 1;
	
	/**
	 * 相册类型，1-最爱
	 * <option value="100">最爱</option>
	 * <option value="101">人物</option>
	 * <option value="102">风景</option>
	 * <option value="103">动物</option>
	 * <option value="104">游记</option>
	 * <option value="105">卡通</option>
	 * <option value="106">生活</option>
	 * <option value="107">其他</option>
	 */
	private int type = 100;
	
	/**
	 * 是否显示
	 * 1-显示
	 * 2-隐藏
	 */
	private int showstate = 1;
	
	/**
	 * 封面
	 */
	private String cover;
	
	/**
	 * 相册描述
	 */
	private String content;
	
	/**
	 * 照片数量（根据上传完成后，重新统计）
	 */
	private Long photocount = 0l;
	
	
	/** 创建日期 (排序)**/
	private Date createDate;
	
	
	
	/**
	 *  创建者 
	 * **/
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="user_id")
	private User user;
	
	/**
	 * 所属单位应用（单位应用）
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="companyApp_id")
	private CompanyApp companyApp;
	
	/**
	 * 所属单位（单位管理号）
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="company_id")
	private Company company;
	
	
}
