package edu.minilive.wedu.entity.app;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import edu.minilive.wedu.entity.User;

/**
 * 微活动报名【微应用】
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-9-29 下午12:01:01
 */
@Entity
@Table(name = "TAB_APP_ACTIVITYAPPLY")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class WeiActvityApply {
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	/**
	 * 微报名ID
	 * @see WeiActvity.id
	 */
	private Long actvityId;
	/**
	 * 用户ID
	 */
	private Long userId;
	/**
	 * 报名时间
	 */
	private Date createDate;
	/**
	 * 报名状态，1-正常报名，2-报名取消
	 */
	private int state = 1;
	
	/**
	 * 用户实体
	 */
	@Transient
	User user;
	
	@Transient
	WeiActvity actvity;
}
