package edu.minilive.wedu.entity.app;

import java.util.Date;
import java.util.List;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.User;

/**
 * 微活动【微应用】
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-9-29 下午12:01:01
 */
@Entity
@Table(name = "TAB_APP_ACTIVITY")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class WeiActvity {
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	/**
	 * 活动名
	 */
	private String name;
	/**
	 * 活动类型	1-默认活动
	 */
	private int type = 1;
	/**
	 * 活动开始时间
	 */
	private Date sDate;
	/**
	 * 活动结束时间
	 */
	private Date eDate;
	
	/**
	 * 联系人
	 */
	private String contacts;
	
	/**
	 * 联系电话
	 */
	private String contactsmobile;
	
	/**
	 * 联系邮箱
	 */
	private String contactsemail;
	
	/**
	 * 活动地点
	 */
	private String addr;
	/**
	 * 限制活动人数
	 */
	private int limitCount;
	/**
	 * 是否公开 1-是，其他-否
	 */
	private int ipublic = 1;
	/**
	 * 积分
	 */
	private int integral = 0;
	/**
	 * 活动图片
	 */
	private String img;
	/**
	 * 活动描述
	 */
	private String content;
	/**
	 * 活动模板，默认加载固定的
	 */
	private String tpl;
	/**
	 * 活动状态，0-未发布，1-已发布，2-已删除
	 */
	private int state = 1;
	
	/**
	 * 所属学校编号
	 */
	private Long schoolId;
	
	/**
	 * 创建用户
	 */
	private Long userId;
	
	/**
	 * 创建时间
	 */
	private Date createDate;
	
	/**
	 * 报名列表
	 */
	@Transient
	List<WeiActvityApply> applyList;
	
	/**
	 * 学校
	 */
	@Transient
	Company school;
	
	/**
	 * 用户实体
	 */
	@Transient
	User user;
	
	
}
