package edu.minilive.wedu.entity;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

/**
 * 用户应用
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-9-27 下午5:12:52
 */
@Entity
@Table(name = "TAB_USER_APP")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class UserApp {
	@Id @GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/**
	 * 所属用户编号
	 */
	private Long userId;
	
	/**
	 * 所属应用编号
	 */
	private Long appId;
	
	/**
	 * 自定义名称
	 */
	private String name;
	
	/**
	 * 自定义图标
	 */
	private String logo;
	
	/**
	 * 是否公开1-是，0-否
	 */
	private int openstate = 1;
	
	/**
	 * 是否设置为快捷管理，1-是，0-否
	 */
	private int mangertop = 0;
	
	/** 创建日期 (排序)**/
	private Date createDate;
	
	@Transient
	private User user;
	
	@Transient
	private App app;
}
