package edu.minilive.wedu.entity;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import edu.minilive.wedu.entity.app.WeiVideo;

/**
 * 广告表
 * @author Janny E-mail:ksgameboy@qq.com
 * @version 1.0
 * @since 1.0
 */
@Entity
@Table(name = "TAB_FOCUSAD")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class FocusAd {
	
	@Id @GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	private  String title;//广告标题
	private  String path;//广告资源地址，http://host/xxx.flv
	private  String url;//广告链接地址，http://companyUrl/
	/**
	 * 
	 * 推荐尺寸：640 : 320
	 */
	private String img;
	/**
	 * 广告类型，1-焦点广告，2-视频缓存广告，3-网站背景图
	 */
	private int type = 1;
	
	/**
	 * @see WeiVideo.subject
	 */
	private int subject = 0;// 广告类型，与Video.subject对应（com.eduvideo.common.bean.SubjectList）
	//9000-新闻类,9001-课程类,9002-娱乐类,9003-活动类,9004-课外类,9005-节目类,9006-宣传片
	
	
	/**频道排序**/
	private int orderNo = 1;
	
	/** 发布人 **/
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="user_id")
	private User user;
	
	/** 状态:1-正常,2-注销**/
	private int state = 1;
	
	/** 创建日期 (排序)**/
	private Date createDate;
	
	private int duration=15;//广告时长，默认15秒
	
	/**
	 * 所属学校
	 * 某个单位设置的，或者是对某个单位设置的广告，NULL表示该广告是属于通用广告
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="school_id")
	private Company school;
	
	
}
