package edu.minilive.wedu.entity;


import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;



/**
 * 区域表
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-8-7 下午4:48:38
 */
@Entity
@Table(name="TAB_DISTRICT")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class District {
	
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 1l; //主键
	
	/**
	 * 区域名称
	 */
	private String name;
	
	/**
	 * 级别
	 */
	private int level = 0;
	
	/**
	 * 上一级
	 */
	private Long parent_id;
	
}
