package edu.minilive.wedu.entity;


import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;


/**
 * 
 * 自定义菜单
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-6-25 下午4:41:05
 */
@Entity
@Table(name = "TAB_CUSTOMMENU")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class CustomMenu {
	
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/**
     * 菜单名称      
     */ 	
	private String name;
	
	/**
	 * 父模块
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="parent_id")
	private CustomMenu parent;
	
	/**
	 * 所属学校
	 * @see Company.id
	 */
	private Long schoolId;
	
	/**
	 * 级别,1-一级栏目,2-二级栏目
	 */
	private int level = 1;
	
	/**
	 * 类型，1：关键词，2：连接地址，3：栏目，4：文章
	 */
	private int type = 1;
	
	/**
	 * 菜单点击事件,唯一键
	 * **/
	private String clickKey;
	
	/**
	 * 触发关键词或外链URL
	 */
	private String tvalue;
	
	/**
	 * 排序
	 */
	private int orderby = 0;
	
	/**
	 * 状态 1-正常，2-注销
	 */
	private int state = 1;
}
