package edu.minilive.wedu.entity;

import java.util.Date;
import java.util.List;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;


/**
 * 微站栏目
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-10-8 下午2:43:47
 */
@Entity
@Table(name="TAB_CHANNEL")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public @Data class Channel {
	
	@Id @GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/**频道名称**/
	private String name; 
	
	/**频道别名**/
	private String alias;
	
	
	/**微信上提醒的功能标题**/
	private String title;
	
	/**父频道**/
	private Long parent_id;
	
	/**创建日期**/
	private Date createDate; 
	
	
	/** 0-微信与页面网站   1-仅适合微信菜单	2-仅适合页面栏目**/
	private int type = 0;
	
	
	/**点击类型,跟微信API对应 
	 *  click（点击事件）: 用户点击click类型按钮后，微信服务器会通过消息接口(event类型)推送点击事件给开发者，并且带上按钮中开发者填写的key值，开发者可以通过自定义的key值进行消息回复。
	 *  view（访问网页）: 用户点击view类型按钮后，会直接跳转到开发者指定的url中。
	 *   **/
	private String clickType = "view";
	
	/**
	 * 用户是否授权访问(需要用户绑定后才可链接)
	 * 1-需要授权	0-不需要(提示需要用户绑定)
	 * **/
	private int clickPermit = 0;
	
	/**
	 * 当clickPermit=1时有效   %s为一次性访问key
	 * 格式:DOMAIN/xx/xx/%s/xx
	 * **/
	private String permitUrl;
	
	/**
	 * 对应clickType
	 * clickType=click:菜单点击事件,唯一键
	 * clickType=view:此字段保存url,用户点击时,直接打开url
	 * **/
	private String clickValue;
	
	/**
	 * clickType=click:	图片,如使用name做为标题,clickValue保存一张图片,WxSendNewsMsg.addItem
	 * 推荐尺寸：64*64
	 */
	private String img;
	
	/**
	 * 回复类型,1-回复当前频道图文链接,0-回复当前频道WXArticle文章列表(最多10条)
	 * clickPermit=0(无需权限)时,网站需要返回消息列表(例如:校园公告)
	 * clickPermit=1(需要权限）时，需要加载模块内容
	 * **/
	private int replyType = 1; 
	
	/**
	 * 级别,1-一级栏目,2-二级栏目,3-三级栏目,....
	 */
	private int level = 1;
	
	/**状态1-正常,2-注销**/
	private int state = 1;
	
	/**频道排序**/
	private int orderNo = 1;
	
	/**
	 * 文章条数（文章添加，修改时做处理）
	 */
	private int articleCount = 0;
	
	/**
	 * 所属学校
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="school_id")
	private Company school;
	
	/**父频道**/
	@Transient
	private Channel parent;
	
	/**
	 * 子目录
	 */
	@Transient
	private List<Channel> subChannelList;
}
