package edu.minilive.wedu.entity;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
/**
 * 自动回复
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-1 下午4:11:27
 */
@Entity
@Table(name="TAB_AUTORESPOND")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class AutoRespond  {
	
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 1l; //主键
	
	/**
	 * 关键词
	 */
	private String tags;
	
	/**
	 * 标题
	 */
	private String title;
	
	/***
	 * 副标题,主要用于微信图文说明
	 */
	private String subtitle;
	
	/**
	 * 图片链接，支持JPG、PNG格式，较好的效果为大图360*200，小图200*200
	 */
	private String img;
	
	/** 状态:1-正常,2-注销**/
	private int state = 1;
	
	/**
	 * 类型0-关注时欢迎消息，1-文字，2-图文
	 */
	private int type = 1;
	
	/**频道排序**/
	private int orderNo = 1;
	
	/**创建日期**/
	private Date createDate; 
	
	//============================图文类型需要以下字段=====================================
	/**
	 * 图文外链类型
	 * 1-链接，2-微网站-首页，3-微网站-栏目，4-微网站-文章
	 */
	private int exttype = 1;
	
	/**
	 * 图文外链内容
	 * 1-链接String  2-微官网首页String	3-微网站-栏目LongID	4-微网站-文章LongID
	 */
	private String extvalue;
	
	/** 创建者 **/
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="user_id")
	private User user;
	
	/**
	 * 所属学校
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="school_id")
	private Company school;
}
