package edu.minilive.wedu.dao.impl;


import java.util.List;

import org.springframework.stereotype.Repository;

import edu.ecompus.core.dao.impl.ML2TemplateGenericDao;
import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.dao.WeiPhotoDAO;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.app.WeiAlbum;
import edu.minilive.wedu.entity.app.WeiPhoto;

/**
 * 
 * <B>微相册</B> 数据持久类 操作接口实现
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-8-7 下午5:25:12
 */
@Repository
public class WeiPhotoDaoImpl extends ML2TemplateGenericDao<WeiPhoto> implements WeiPhotoDAO {

	public WeiPhotoDaoImpl() {
		super(WeiPhoto.class);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<WeiPhoto> queryPhotoListByToken(String token, Company company,
			Page page) {
		StringBuffer sql = new StringBuffer("from WeiPhoto where state=1 ");
		if(token!=null && !"".equals(token)){
			sql.append(" and token='").append(token).append("'");
		}
		
		if(company!=null){
			sql.append(" and company.id=").append(company.getId());
		}
		
		sql.append(" order by createDate desc");
		
		if(page!=null){
			return this.queryForList(
					"select count(*) " + sql.toString(),
					sql.toString(),
					new Object[] {}, page);
		}else{
			return this.hibernateTemplate.find(sql.toString());
		}
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<WeiPhoto> queryPhotoListByCompany(String title,
			Company company, WeiAlbum weiAlbum, Page page) {
		StringBuffer sql = new StringBuffer("from WeiPhoto where state=1 ");
		if(title!=null && !"".equals(title)){
			sql.append(" and title like '%").append(title).append("%'");
		}
		
		if(company!=null){
			sql.append(" and company.id=").append(company.getId());
		}
		
		if(weiAlbum!=null){
			sql.append(" and weiAlbum.id=").append(weiAlbum.getId());
		}
		
		sql.append(" order by createDate desc");
		
		if(page!=null){
			return this.queryForList(
					"select count(*) " + sql.toString(),
					sql.toString(),
					new Object[] {}, page);
		}else{
			return this.hibernateTemplate.find(sql.toString());
		}
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<WeiPhoto> queryPhotoListByIds(String photoIds, Company company,
			WeiAlbum weiAlbum, Page page) {
		StringBuffer sql = new StringBuffer("from WeiPhoto where id>0");
		
		if(photoIds!=null && !"".equals(photoIds)){
			sql.append(" and id in (").append(photoIds).append(")");
		}
		
		if(company!=null){
			sql.append(" and company.id=").append(company.getId());
		}
		
		if(weiAlbum!=null){
			sql.append(" and weiAlbum.id=").append(weiAlbum.getId());
		}
		
		sql.append(" order by createDate asc");
		
		if(page!=null){
			return this.queryForList(
					"select count(*) " + sql.toString(),
					sql.toString(),
					new Object[] {}, page);
		}else{
			return this.hibernateTemplate.find(sql.toString());
		}
	}

	@Override
	public Long countAlbumPhoto(WeiAlbum weiAlbum) {
		StringBuffer sql = new StringBuffer("select count(id) from eduwxjy.TAB_APP_WEIPHOTO where state=1 ");
		
		if(weiAlbum!=null){
			sql.append(" and weiAlbum_id=").append(weiAlbum.getId());
		}
		
		return this.jdbcTemplate.queryForLong(sql.toString());
				
//		return (long) this.executeUpdate(
//				sql.toString(),
//				new Object[] {  });
		
//		return  (Long) this.queryForObject(sql.toString(),
//				new Object[]{});
	}

	
	

}
