package edu.minilive.wedu.dao.impl;


import java.util.List;

import org.springframework.stereotype.Repository;

import edu.ecompus.core.dao.impl.ML2TemplateGenericDao;
import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.dao.UserDAO;
import edu.minilive.wedu.entity.User;


/**
 * 用户数据持久类 操作接口实现
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author Author：        <JannyShao>
 * Create Date：  <2013-6-24 下午1:54:24>
 */ 
@Repository
public class UserDaoImpl extends ML2TemplateGenericDao<User> implements UserDAO {

	public UserDaoImpl() {
		super(User.class);
	}

	@Override
	public User getUser(String username) {
		StringBuffer sql = new StringBuffer("from User where id>0 ");
		sql.append(" and username='").append(username).append("'");
		
		return (User) this.queryForObject(sql.toString(), null);
	}

	@SuppressWarnings("unchecked")
	@Override
	public User getUserByNickName(String nickname) {
		StringBuffer sql = new StringBuffer("from User where id>0");
		sql.append(" and nickname='").append(nickname).append("'");
		
		List<User> list = this.hibernateTemplate.find(sql.toString());
		if(list!=null && list.size()>0){
			return list.get(0);
		}
		
		return null;
	}
	
	@Override
	public User getUser(String username, String password) {
		StringBuffer sql = new StringBuffer("from User where id>0");
		sql.append(" and username='").append(username).append("'");
		sql.append(" and password='").append(password).append("'");
		
		return (User) this.queryForObject(sql.toString(), null);
	}

	@Override
	public List<User> queryUserList(String keyword, int enabled,
			String mobile, String identity) {
		return this.queryUserList(keyword, enabled, mobile, identity, null);
	}


	@SuppressWarnings("unchecked")
	@Override
	public List<User> queryUserByIds(String ids) {
		return this.hibernateTemplate.find("from User where id in ("+ids+")");
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<User> queryAll() {
		return this.findAll();
	}

	@Override
	public int setUserFace(User user) {
		StringBuffer sql = new StringBuffer("UPDATE User SET userface=?  where id=?");
		return this.executeUpdate(sql.toString(), new Object[]{user.getUserface(),user.getId()});
	}

	@Override
	public User queryUserById(Long userId) {
		StringBuffer sql = new StringBuffer("from User where id=");
		sql.append(userId);
		return (User) this.queryForObject(sql.toString(), null);
	}





	@SuppressWarnings("unchecked")
	@Override
	public User getUserByMobile(String mob) {
		StringBuffer sql = new StringBuffer("from User where enable=1 and mobile='").append(mob).append("'");
		List<User> list = this.hibernateTemplate.find(sql.toString());
		if(list!=null && list.size()>0){
			return list.get(0);
		}
		// TODO Auto-generated method stub
		return null;
	}

	
	@SuppressWarnings("unchecked")
	@Override
	public User getUserByName(String name) {
		StringBuffer sql = new StringBuffer("from User where id>0");
		sql.append(" and name='").append(name).append("'");
		
		List<User> list = this.hibernateTemplate.find(sql.toString());
		if(list!=null && list.size()>0){
			return list.get(0);
		}
		
		return null;
	}
	

	@SuppressWarnings("unchecked")
	@Override
	public List<User> queryUserList(String keyword,
			int enabled, String mobile, String identity, Page page) {
		
		StringBuffer sql = new StringBuffer("from User where id>0 ");
		if(keyword!=null && !"".equals(keyword)){
			sql.append(" and ( name like '%").append(keyword).append("%'");
			sql.append(" or nickname like '%").append(keyword).append("%' )");
		}
		
		if(enabled!=-1){
			sql.append(" and enable=").append(enabled);
		}
		
		if(mobile!=null && !"".equals(mobile)){
			sql.append(" and mobile like '%").append(mobile).append("%'");
		}
		
		if(identity!=null && !"".equals(identity)){
			sql.append(" and identity like '%").append(identity).append("%'");
		}
		
		
		if(page==null){
			return this.hibernateTemplate.find(sql.toString());
		}
		
		return this.queryForList("select count(*) " + sql.toString(),
				sql.toString(), new Object[] {}, page);
		
	}

	@Override
	public User queryUserByQQ(String qqId) {
		StringBuffer sql = new StringBuffer("from User where id>0 ");
		sql.append(" and qqId='").append(qqId).append("'");
		
		return (User) this.queryForObject(sql.toString(), null);
	}

}
