package edu.minilive.wedu.dao.impl;


import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import edu.ecompus.core.dao.impl.ML2TemplateGenericDao;
import edu.minilive.wedu.dao.JdbcObjectDAO;
import edu.minilive.wedu.module.SO.WXMessageCount;

/**
 * <b>VO</b> 数据持久类 操作接口实现
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-10-25 下午2:56:45
 */
@Repository
public class JdbcObjectDaoImpl extends ML2TemplateGenericDao<Object> implements
		JdbcObjectDAO {

	public JdbcObjectDaoImpl() {
		super(Object.class);
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	@Override
	public WXMessageCount queryWXMessage(Long schoolId) {
		StringBuffer sql = new StringBuffer("SELECT ");
		sql.append(" (SELECT count(id) FROM `eduwxjy`.TAB_WXMESSAGES where schoolId=").append(schoolId).append(" and messageType='text') as textcount,");
		sql.append(" (SELECT count(id) FROM `eduwxjy`.TAB_WXMESSAGES where schoolId=").append(schoolId).append(" and messageType='image') as imagecount,");
		sql.append(" (SELECT count(id) FROM `eduwxjy`.TAB_WXMESSAGES where schoolId=").append(schoolId).append(" and messageType='voice') as voicecount,");
		sql.append(" (SELECT count(id) FROM `eduwxjy`.TAB_WXMESSAGES where schoolId=").append(schoolId).append(" and messageType='video') as videocount,");
		sql.append(" (SELECT count(id) FROM `eduwxjy`.TAB_WXMESSAGES where schoolId=").append(schoolId).append(" and messageType='location') as locationcount,");
		sql.append(" (SELECT count(id) FROM `eduwxjy`.TAB_WXMESSAGES where schoolId=").append(schoolId).append(" and messageType='link') as linkcount");
		/**
		 select
		(SELECT count(id) FROM `eduwxjy`.TAB_WXMESSAGES where schoolId=1 and messageType='text') as textcount,
		(SELECT count(id) FROM `eduwxjy`.TAB_WXMESSAGES where schoolId=1 and messageType='image') as imagecount,
		(SELECT count(id) FROM `eduwxjy`.TAB_WXMESSAGES where schoolId=1 and messageType='voice') as voicecount,
		(SELECT count(id) FROM `eduwxjy`.TAB_WXMESSAGES where schoolId=1 and messageType='video') as videocount,
		(SELECT count(id) FROM `eduwxjy`.TAB_WXMESSAGES where schoolId=1 and messageType='location') as locationcount,
		(SELECT count(id) FROM `eduwxjy`.TAB_WXMESSAGES where schoolId=1 and messageType='link') as linkcount
		 */
		logger.info("根据学校ID查询学校历史消息数SQL:"+sql.toString());
		return (WXMessageCount) jdbcTemplate.query(sql.toString(), new ResultSetExtractor() {
			public Object extractData(ResultSet rs) throws SQLException, DataAccessException {
				WXMessageCount vo = new WXMessageCount();
				
				while (rs.next()) {
					vo.setAudioCount(rs.getLong("voicecount"));
					vo.setGpsCount(rs.getLong("locationcount"));
					vo.setImageCount(rs.getLong("imagecount"));
					vo.setTextCount(rs.getLong("textcount"));
					vo.setVideoCount(rs.getLong("videocount"));
					vo.setWebsiteCount(rs.getLong("linkcount"));
				}
				return vo;
			}
		});
	}


	

}
