package edu.minilive.wedu.dao.impl;


import java.util.List;

import org.springframework.stereotype.Repository;

import edu.ecompus.core.dao.impl.ML2TemplateGenericDao;
import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.dao.CompanyDAO;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.District;

/**
 * 
 * <b>单位</b> 数据持久类 操作接口实现
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-7-12 下午4:10:30
 */
@Repository
public class CompanyDaoImpl extends ML2TemplateGenericDao<Company> implements
		CompanyDAO {

	public CompanyDaoImpl() {
		super(Company.class);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Company> queryCompanyList() {
		return this.findAll();
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Company> queryCompanyListByKey(String companyName, int status,
			Long provinceId, Long cityId, Long areaId) {
		StringBuffer sql = new StringBuffer("from Company where id>0");
		if (companyName != null && !"".equals(null)) {
			sql.append("and name like '%").append(companyName).append("%'");
		}
		if (status > -1) {
			sql.append("and status = ").append(status);
		}
		if (provinceId != null && provinceId>0l) {
			sql.append("and province.id=").append(provinceId);
		}
		if (cityId != null && cityId>0l) {
			sql.append("and city.id=").append(cityId);
		}
		if (areaId != null && areaId>0l) {
			sql.append("and area.id=").append(areaId);
		}
		
		return this.hibernateTemplate.find(sql.toString(), new Object[]{});
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Company> queryCompanyListBySystem(String keyword, int status,
			Page page) {
		StringBuffer sql = new StringBuffer("from Company where id>0");
		if(status!=-1){
			sql.append(" and status=").append(status);
		}
		
		if(keyword!=null && !"".equals(keyword)){
			sql.append(" and (name like '%").append(keyword).append("%'");
			sql.append(" 	or alias like '%").append(keyword).append("%'");
			sql.append(" 	or contact like '%").append(keyword).append("%'");
			sql.append(" 	or telphone like '%").append(keyword).append("%'");
			sql.append(" 	or website like '%").append(keyword).append("%'");
			sql.append(" 	or address like '%").append(keyword).append("%'");
			sql.append(" 	or postcode like '%").append(keyword).append("%'");
			sql.append(" 	or email like '%").append(keyword).append("%')");
		}
		
		sql.append(" order by createDate desc");
		
		return this.queryForList("select count(*) " + sql.toString(),
				sql.toString(), new Object[] {  }, page);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Company> queryCompanyListBySystem(String keyword, int type,
			int subtype, int status, District province, District city,
			int vertystate, Page page) {
		StringBuffer sql = new StringBuffer("from Company where id>0");
		if(status!=-1){
			sql.append(" and status=").append(status);
		}
		
		if(vertystate!=-1){
			sql.append(" and vertystate=").append(vertystate);
		}
		
		if(province!=null){
			sql.append(" and province.id=").append(province.getId());
		}
		
		if(city!=null){
			sql.append(" and city.id=").append(city.getId());
		}
		
		if(type>0){
			sql.append(" and type=").append(type);
		}
		
		if(subtype>0){
			sql.append(" and subtype=").append(subtype);
		}
		
		if(keyword!=null && !"".equals(keyword)){
			sql.append(" and (name like '%").append(keyword).append("%'");
			sql.append(" 	or alias like '%").append(keyword).append("%'");
			sql.append(" 	or contact like '%").append(keyword).append("%'");
			sql.append(" 	or telphone like '%").append(keyword).append("%'");
			sql.append(" 	or website like '%").append(keyword).append("%'");
			sql.append(" 	or address like '%").append(keyword).append("%'");
			sql.append(" 	or postcode like '%").append(keyword).append("%'");
			sql.append(" 	or email like '%").append(keyword).append("%')");
		}
		
		sql.append(" order by createDate desc");
		
		if(page==null){
			return this.hibernateTemplate.find(sql.toString());
		}
		
		return this.queryForList("select count(*) " + sql.toString(), sql.toString(),
				new Object[] {}, page);
	}


}
