package edu.minilive.wedu.dao.impl;


import java.util.List;

import org.springframework.stereotype.Repository;

import edu.ecompus.core.dao.impl.ML2TemplateGenericDao;
import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.dao.AutoRespondDAO;
import edu.minilive.wedu.entity.AutoRespond;
/**
 * 
 * <b>个人中心应用管理DAO</b> 数据持久类 操作接口实现
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-7-12 下午4:10:30
 */
@Repository
public class AutoRespondDaoImpl extends ML2TemplateGenericDao<AutoRespond> implements
		AutoRespondDAO {

	public AutoRespondDaoImpl() {
		super(AutoRespond.class);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<AutoRespond> queryAutoRespondListByCompany(Long schoolId,
			Page page) {
		StringBuffer sql = new StringBuffer("from AutoRespond where state=1 ");
		
		if(schoolId!=null && schoolId>0){
			sql.append(" and school.id=").append(schoolId);
		}
		
		sql.append(" order by orderNo desc, createDate desc");
		if(page==null){
			return this.hibernateTemplate.find(sql.toString());
		}
		
		return this.queryForList("select count(*) " + sql.toString(), sql.toString(),
				new Object[] {}, page);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<AutoRespond> queryAutoRespondListByType(Long schoolid,
			int type, Page page) {
		StringBuffer sql = new StringBuffer("from AutoRespond where state=1 ");
		
		if(schoolid!=null && schoolid>0){
			sql.append(" and school.id=").append(schoolid);
		}
		
		if(type!=-1){
			sql.append(" and type=").append(type);
		}
		
		sql.append(" order by orderNo desc, createDate desc");
		if(page==null){
			return this.hibernateTemplate.find(sql.toString());
		}
		
		return this.queryForList("select count(*) " + sql.toString(), sql.toString(),
				new Object[] {}, page);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<AutoRespond> queryAutoRespondByClickKey(Long schoolid,
			String keyId, Page page) {
		StringBuffer sql = new StringBuffer("from AutoRespond where state=1 ");
		
		if(schoolid!=null && schoolid>0){
			sql.append(" and school.id=").append(schoolid);
		}
		
		if(keyId!=null && !"".equals(keyId)){
			sql.append(" and tags='").append(keyId).append("'");
		}
		
		sql.append(" order by orderNo desc, createDate desc");
		
		this.logger.info("queryAutoRespondByClickKey:"+sql.toString());
		
		if(page==null){
			return this.hibernateTemplate.find(sql.toString());
		}
		
		return this.queryForList("select count(*) " + sql.toString(), sql.toString(),
				new Object[] {}, page);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<AutoRespond> queryAutoRespondByClickKeyLike(Long schoolid,
			String likekey, Page page) {
		StringBuffer sql = new StringBuffer("from AutoRespond where state=1 ");
		
		if(schoolid!=null && schoolid>0){
			sql.append(" and school.id=").append(schoolid);
		}
		
		if(likekey!=null && !"".equals(likekey)){
			sql.append(" and tags like '%").append(likekey).append("%'");
		}
		
		sql.append(" order by orderNo desc, createDate desc");
		
		
		if(page==null){
			return this.hibernateTemplate.find(sql.toString());
		}
		
		return this.queryForList("select count(*) " + sql.toString(), sql.toString(),
				new Object[] {}, page);
	}


}
