package edu.minilive.wedu.dao.app.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import edu.ecompus.core.dao.impl.ML2TemplateGenericDao;
import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.dao.app.WeiVoteDAO;
import edu.minilive.wedu.entity.app.WeiVote;
/**
 * <b>微投票</b> 数据持久类 操作接口实现
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-10-27 上午10:54:58
 */
@Repository
public class WeiVoteDaoImpl extends ML2TemplateGenericDao<WeiVote> implements
		WeiVoteDAO {

	public WeiVoteDaoImpl() {
		super(WeiVote.class);
	}


	@Override
	public List<WeiVote> queryVoteBySchoolId(Long schoolId) {
		return queryVoteList(schoolId, "", 1, null);
	}


	@SuppressWarnings("unchecked")
	@Override
	public List<WeiVote> queryVoteList(Long schoolId, String keyword,
			int state, Page page) {
		StringBuffer sql = new StringBuffer("from WeiVote where id>0 ");
		if(schoolId!=null && schoolId>0){
			sql.append(" and schoolId=").append(schoolId);
		}
		
		if(keyword!=null && !"".equals(keyword)){
			sql.append(" and title like '%").append(keyword).append("%'");
		}
		
		if(state!=-1){
			sql.append(" and state=").append(state);
		}
		
		sql.append(" order by createDate desc");
		
		if(page==null){
			return this.hibernateTemplate.find(sql.toString());
		}
		
		return this.queryForList("select count(*) " + sql.toString(),
				sql.toString(), new Object[] {  }, page);
	}

}
