package edu.minilive.wedu.dao.app.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import edu.ecompus.core.dao.impl.ML2TemplateGenericDao;
import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.dao.app.WeiActvityApplyDAO;
import edu.minilive.wedu.entity.app.WeiActvityApply;

/**
 * <b>微活动-报名记录</b> 数据持久类 操作接口实现
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-10-27 上午10:54:58
 */
@Repository
public class WeiActvityApplyDaoImpl extends ML2TemplateGenericDao<WeiActvityApply> implements
		WeiActvityApplyDAO {

	public WeiActvityApplyDaoImpl() {
		super(WeiActvityApply.class);
	}


	@SuppressWarnings("unchecked")
	@Override
	public List<WeiActvityApply> queryWeiActvityApply(Long actvityId, Long userId, int state) {
		StringBuffer sql = new StringBuffer("from WeiActvityApply where id>0 ");
		if(actvityId!=null && actvityId>0){
			sql.append(" and actvityId=").append(actvityId);
		}
		
		if(userId!=null && userId>0){
			sql.append(" and userId=").append(userId);
		}
		
		if(state==-2){
			sql.append(" and (state=0 or state=1)");
		}else if(state!=-1){
			sql.append(" and state=").append(state);
		}
		
		sql.append(" order by createDate desc");
		
		return this.hibernateTemplate.find(sql.toString());
	}


	@SuppressWarnings("unchecked")
	@Override
	public List<WeiActvityApply> queryWeiActvityApply(Long userId, int state, Page page) {
		StringBuffer sql = new StringBuffer("from WeiActvityApply where id>0 ");
		if(userId!=null && userId>0){
			sql.append(" and userId=").append(userId);
		}
		
		if(state!=-1){
			sql.append(" and state=").append(state);
		}
		
		sql.append(" order by createDate desc");
		
		if(page==null){
			return this.hibernateTemplate.find(sql.toString());
		}
		
		return this.queryForList("select count(*) " + sql.toString(),
				sql.toString(), new Object[] {  }, page);
	}

}
