package edu.minilive.wedu.dao.app;

import java.util.List;

import edu.ecompus.core.dao.ML2GenericDao;
import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.entity.app.WeiVote;
/**
 * <b>微投票</b> 数据持久类 操作接口定义
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-10-27 上午10:36:43
 */
public interface WeiVoteDAO extends ML2GenericDao<WeiVote> {
	/**
	 * 根据学校Id查询投票
	 * @param schoolId		学校ID
	 * @return
	 */
	List<WeiVote> queryVoteBySchoolId(Long schoolId);
	
	/**
	 * 查询学校投票列表
	 * @param schoolId
	 * @param keyword
	 * @param state
	 * @param page
	 * @return
	 */
	List<WeiVote> queryVoteList(Long schoolId, String keyword, int state, Page page);
}
