package edu.minilive.wedu.dao;

import java.util.List;

import edu.ecompus.core.dao.ML2GenericDao;
import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.FocusAd;

/**
 * <B>焦点广告</B> 数据持久类 操作接口定义
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-8-7 下午5:18:34
 */
public interface FocusAdDAO extends ML2GenericDao<FocusAd> {
	/**
	 * 查询单位广告列表【单位后台】
	 * @param company		所属单位（不能为NULL)
	 * @param keyword		关键词（NULL或者空不为条件）
	 * @param type			广告类型（-1不为条件）
	 * @param page			分页
	 * @return
	 */
	List<FocusAd> queryFocusAdByCompany(Company company, String keyword,int type, Page page);
	
	/**
	 * 根据类型查询广告列表
	 * @param type
	 * @return
	 */
	List<FocusAd>  queryFocusAdByType(int type);
}
