package edu.minilive.wedu.dao;

import java.util.List;

import edu.ecompus.core.dao.ML2GenericDao;
import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.entity.Company;
import edu.minilive.wedu.entity.District;

/**
 * 
 * <b>单位</b> 数据持久类 操作接口定义
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-7-12 下午4:10:30
 */
public interface CompanyDAO extends ML2GenericDao<Company> {

	/**
	 * 获取所有学校数据
	 * @return
	 */
	List<Company> queryCompanyList();
	
	/**
	 * 条件查询学校表数据
	 * @param company
	 * @param province
	 * @param city
	 * @param area
	 * @return
	 */
	List<Company> queryCompanyListByKey(String companyName, int status, Long provinceId, Long cityId, Long areaId);
	
	/**
	 * []验证开通幼儿园数据
	 * @param keyword		关键词(NULL不为条件,学校名称,学校别名,联系人,电话,网址 ,地址,邮编,邮箱)
	 * @param status		状态(-1不为条件,0-全部
	 * @param page			分页
	 * @return
	 */
	List<Company> queryCompanyListBySystem(String keyword, int status, Page page);
	
	
	/**
	 * []验证开通幼儿园数据
	 * @param keyword		关键词(NULL不为条件,学校名称,学校别名,联系人,电话,网址 ,地址,邮编,邮箱)
	 * @param status		状态(-1不为条件,0-全部
	 * @param vertystate	审核	状态(-1不为条件,
	 * @param page			分页
	 * @return
	 */
	List<Company> queryCompanyListBySystem(String keyword, int type, int subtype, int status,District province, District city,int vertystate, Page page);
}
