package edu.minilive.wedu.dao;

import java.util.List;

import edu.ecompus.core.dao.ML2GenericDao;
import edu.minilive.wedu.entity.App;
import edu.minilive.wedu.entity.CompanyApp;
/**
 * 
 * <b>单位应用</b> 数据持久类 操作接口定义
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-7-12 下午4:10:30
 */
public interface CompanyAppDAO extends ML2GenericDao<CompanyApp> {
	/**
	 * 查询学校所有APP
	 * @param school		*学校
	 * @param apptype		应用类型(-1不为条件,1-微博应用[适用于全校用户],2-OA应用[适用于教师用户)
	 * @param appalias		应用别名(示：WeiPhoto，WeiVideo...)
	 * @param app			应用实体
	 * @param state			应用状态(-1不为条件,1-启动,2-禁用)
	 * @return
	 */
	List<CompanyApp> queryCompanyApp(Long schoolId, String appalias,App app,  int apptype, int state, int showApp);
	
}
