package edu.minilive.wedu.dao;

import java.util.List;

import edu.ecompus.core.dao.ML2GenericDao;
import edu.ecompus.core.entity.Page;
import edu.minilive.wedu.entity.App;

/**
 * 
 * 应用 数据持久类 操作接口定义
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-7-12 下午4:10:30
 */
public interface AppDAO extends ML2GenericDao<App> {
	
	/**
	 * * 分页读取应用(状态:正常)列表
	 * @param page		分页实体@see edu.ecompus.core.entity.Page
	 * @return
	 */
	List<App> queryAppList(Page page);
	
	/**
	 * 根据clientId查询App
	 * @param clientId
	 * @return
	 */
	App queryClientByClientId(String clientId);
	
	/**
	 * 根据Alias查询App
	 * @param Alias
	 * @return
	 */
	App queryAppByAlias(String Alias);
	
	/**
	 * 查询允许用户开通服务的应用列表
	 */
	List<App> queryAppsByUser();
}
