/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.weixin.parser;

import edu.ecompus.weixin.parser.WxRecvMsgBaseParser;
import edu.ecompus.weixin.vo.recv.WxRecvGeoMsg;
import edu.ecompus.weixin.vo.recv.WxRecvMsg;
import org.jdom.Element;
import org.jdom.JDOMException;

public class WxRecvGeoMsgParser
extends WxRecvMsgBaseParser {
    @Override
    protected WxRecvGeoMsg parser(Element root, WxRecvMsg msg) throws JDOMException {
        String locationX = this.getElementText(root, "Location_X");
        String locationY = this.getElementText(root, "Location_Y");
        int scale = this.parseInt(this.getElementText(root, "Scale"), 0);
        String label = this.getElementText(root, "Label");
        double latitude = this.parseDouble(locationX, 0.0);
        double longitude = this.parseDouble(locationY, 0.0);
        return new WxRecvGeoMsg(msg, latitude, longitude, scale, label);
    }

    private double parseDouble(String val, double def) {
        try {
            return Double.parseDouble(val);
        }
        catch (Exception e) {
            return def;
        }
    }

    private int parseInt(String val, int def) {
        try {
            return Integer.parseInt(val);
        }
        catch (Exception e) {
            return def;
        }
    }
}

