/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.weixin;

import edu.ecompus.weixin.WeiXin;
import edu.ecompus.weixin.vo.UserItem;
import edu.ecompus.weixin.vo.UserPageList;
import edu.ecompus.weixin.vo.WxReturnJson;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeiXinUserUtil {
    static Logger log = LoggerFactory.getLogger(WeiXinUserUtil.class);

    public static UserItem getUserByOpenId(String openId, String token, String lang) {
        String url = String.format("https://api.weixin.qq.com/cgi-bin/user/info?access_token=%s&openid=%s&lang=%s", token, openId, lang);
        JSONObject json = WeiXin.get(url, "");
        log.info("\u83b7\u53d6\u7528\u6237\u57fa\u672c\u4fe1\u606f\uff1a" + json.toString());
        if (json != null && json.get("subscribe") != null) {
            return new UserItem(json);
        }
        return null;
    }

    public static WxReturnJson editUserRemark(String openId, String remark, String token) {
        String url = String.format("https://api.weixin.qq.com/cgi-bin/user/info/updateremark?access_token=%s", token);
        StringBuilder data = new StringBuilder("{\"openid\":\"").append(openId).append(",\"remark\":\"").append(remark).append("\"}");
        JSONObject json = WeiXin.send(url, data.toString());
        log.info("\u8bbe\u7f6e\u5907\u6ce8\u540d\uff1a" + json.toString());
        if (json != null && json.get("errcode") != null) {
            WxReturnJson result = new WxReturnJson(json);
            result.setErrcode(json.getString("errcode"));
            result.setErrmsg(json.getString("errmsg"));
            return result;
        }
        return null;
    }

    public static UserPageList getUsers(String nextOpenid, String token) {
        String url = String.format("https://api.weixin.qq.com/cgi-bin/user/get?access_token=%s&next_openid=%s", token, nextOpenid);
        JSONObject json = WeiXin.get(url, "");
        log.info("\u83b7\u53d6\u5173\u6ce8\u8005\u5217\u8868\uff1a" + json.toString());
        if (json != null && json.get("total") != null) {
            return new UserPageList(json);
        }
        return null;
    }
}

