/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.weixin;

import edu.ecompus.weixin.HashKitUtil;
import edu.ecompus.weixin.parser.WxMsgKit;
import edu.ecompus.weixin.vo.UserInfoCode;
import edu.ecompus.weixin.vo.UserItem;
import edu.ecompus.weixin.vo.recv.WxRecvMsg;
import edu.ecompus.weixin.vo.send.WxSendMsg;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import net.sf.json.JSONObject;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WeiXin {
    static Logger log = LoggerFactory.getLogger(WeiXin.class);

    public static JSONObject send(String urlPath, String data) {
        try {
            URL url = new URL(urlPath);
            HttpURLConnection http = (HttpURLConnection)url.openConnection();
            http.setRequestMethod("POST");
            http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            http.setDoOutput(true);
            http.setDoInput(true);
            System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
            System.setProperty("sun.net.client.defaultReadTimeout", "30000");
            http.connect();
            OutputStream os = http.getOutputStream();
            os.write(data.getBytes("UTF-8"));
            os.flush();
            os.close();
            InputStream is = http.getInputStream();
            int size = is.available();
            byte[] jsonBytes = new byte[size];
            is.read(jsonBytes);
            String message = new String(jsonBytes, "UTF-8");
            return JSONObject.fromObject((Object)message);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static JSONObject get(String urlPath, String data) {
        try {
            URL url = new URL(urlPath);
            HttpURLConnection http = (HttpURLConnection)url.openConnection();
            http.setRequestMethod("GET");
            http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            http.setDoOutput(true);
            http.setDoInput(true);
            System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
            System.setProperty("sun.net.client.defaultReadTimeout", "30000");
            http.connect();
            OutputStream os = http.getOutputStream();
            os.write(data.getBytes("UTF-8"));
            os.flush();
            os.close();
            InputStream is = http.getInputStream();
            int size = is.available();
            byte[] jsonBytes = new byte[size];
            is.read(jsonBytes);
            String message = new String(jsonBytes, "UTF-8");
            return JSONObject.fromObject((Object)message);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getAccess_token(String APPID, String APPSECRET) throws Exception {
        if (log.isInfoEnabled()) {
            log.info("getAccess_token \u83b7\u53d6access_token APPID=" + APPID + " APPSECRET=" + APPSECRET);
        }
        String url = String.format("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s", APPID, APPSECRET);
        URL urlGet = new URL(url);
        HttpURLConnection http = (HttpURLConnection)urlGet.openConnection();
        http.setRequestMethod("GET");
        http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        http.setDoOutput(true);
        http.setDoInput(true);
        System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
        System.setProperty("sun.net.client.defaultReadTimeout", "30000");
        http.connect();
        InputStream is = http.getInputStream();
        int size = is.available();
        byte[] jsonBytes = new byte[size];
        is.read(jsonBytes);
        String message = new String(jsonBytes, "UTF-8");
        JSONObject demoJson = JSONObject.fromObject((Object)message);
        return demoJson.getString("access_token");
    }

    public static String getjsapi_ticket(String accesstoken) throws Exception {
        log.info("getjsapi_ticket \u83b7\u53d6jsapi_ticket accesstoken=" + accesstoken);
        String url = String.format("https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=%s&type=jsapi", accesstoken);
        URL urlGet = new URL(url);
        HttpURLConnection http = (HttpURLConnection)urlGet.openConnection();
        http.setRequestMethod("GET");
        http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        http.setDoOutput(true);
        http.setDoInput(true);
        System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
        System.setProperty("sun.net.client.defaultReadTimeout", "30000");
        http.connect();
        InputStream is = http.getInputStream();
        int size = is.available();
        byte[] jsonBytes = new byte[size];
        is.read(jsonBytes);
        String message = new String(jsonBytes, "UTF-8");
        JSONObject demoJson = JSONObject.fromObject((Object)message);
        return demoJson.getString("ticket");
    }

    public static UserInfoCode getUserAccessTokenByCode(String APPID, String APPSECRET, String code) throws Exception {
        log.info("getUserAccessTokenByCode code=" + code);
        String url = String.format("https://api.weixin.qq.com/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code", APPID, APPSECRET, code);
        URL urlGet = new URL(url);
        HttpURLConnection http = (HttpURLConnection)urlGet.openConnection();
        http.setRequestMethod("GET");
        http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        http.setDoOutput(true);
        http.setDoInput(true);
        System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
        System.setProperty("sun.net.client.defaultReadTimeout", "30000");
        http.connect();
        InputStream is = http.getInputStream();
        int size = is.available();
        byte[] jsonBytes = new byte[size];
        is.read(jsonBytes);
        String message = new String(jsonBytes, "UTF-8");
        log.info(message);
        return new UserInfoCode(JSONObject.fromObject((Object)message));
    }

    public static UserItem getUserInfo(String accessToken, String openid) throws Exception {
        log.info("getUserInfo accessToken=" + accessToken + ", openid=" + openid);
        String url = String.format("https://api.weixin.qq.com/sns/userinfo?access_token=%s&openid=%s&lang=zh_CN", accessToken, openid);
        URL urlGet = new URL(url);
        HttpURLConnection http = (HttpURLConnection)urlGet.openConnection();
        http.setRequestMethod("GET");
        http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        http.setDoOutput(true);
        http.setDoInput(true);
        System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
        System.setProperty("sun.net.client.defaultReadTimeout", "30000");
        http.connect();
        InputStream is = http.getInputStream();
        int size = is.available();
        byte[] jsonBytes = new byte[size];
        is.read(jsonBytes);
        String message = new String(jsonBytes, "UTF-8");
        log.info(message);
        return new UserItem(JSONObject.fromObject((Object)message));
    }

    public static boolean access(String token, String signature, String timestamp, String nonce) {
        if (log.isInfoEnabled()) {
            log.info("access checkSignature");
            log.info("\t\t\tsignature=" + signature);
            log.info("\t\t\ttimestamp=" + timestamp);
            log.info("\t\t\tnonce=" + nonce);
        }
        ArrayList<String> ss = new ArrayList<String>();
        ss.add(timestamp);
        ss.add(nonce);
        ss.add(token);
        Collections.sort(ss);
        StringBuilder builder = new StringBuilder();
        for (String s : ss) {
            builder.append(s);
        }
        return signature.equalsIgnoreCase(HashKitUtil.sha1(builder.toString()));
    }

    public static WxRecvMsg recv(InputStream in) throws JDOMException, IOException {
        if (log.isInfoEnabled()) {
            log.info("recv in is not null?" + (in != null));
        }
        return WxMsgKit.parse(in);
    }

    public static void send(WxSendMsg msg, OutputStream out) throws JDOMException, IOException {
        Document doc;
        if (log.isInfoEnabled()) {
            log.info("send msg=" + msg);
        }
        if (null != (doc = WxMsgKit.parse(msg))) {
            new XMLOutputter().output(doc, out);
        } else if (log.isInfoEnabled()) {
            log.info("\u53d1\u9001\u6d88\u606f\u65f6,\u89e3\u6790\u51fadom\u4e3a\u7a7a msg :" + msg);
        }
    }

    public static WxSendMsg builderSendByRecv(WxRecvMsg msg) {
        if (log.isInfoEnabled()) {
            log.info("builderSendByRecv msg=" + msg);
        }
        WxRecvMsg m = new WxRecvMsg(msg);
        String from = m.getFromUser();
        m.setFromUser(m.getToUser());
        m.setToUser(from);
        m.setCreateDt(String.valueOf(System.currentTimeMillis() / 1000L));
        return new WxSendMsg(m);
    }
}

