package edu.ecompus.weixin.vo.recv;
/**
 * 接收语音识别结果
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <开通语音识别功能，用户每次发送语音给公众号时，微信会在推送的语音消息XML数据包中，增加一个Recongnition字段。>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-8-30 下午2:21:33
 */
public class WxVoiceRecognitionMsg extends WxRecvMsg {
	/**
	 * 语音消息媒体id，可以调用多媒体文件下载接口拉取该媒体
	 */
	private String mediaID;
	/**
	 * 语音格式：amr
	 */
	private String format;
	/**
	 * 语音识别结果，UTF8编码
	 */
	private String recognition;
	
	public WxVoiceRecognitionMsg(WxRecvMsg msg,String mediaID, String format, String recognition) {
		super(msg);
		this.mediaID = mediaID;
		this.format = format;
		this.recognition = recognition;
	}

	public String getMediaID() {
		return mediaID;
	}

	public void setMediaID(String mediaID) {
		this.mediaID = mediaID;
	}

	public String getFormat() {
		return format;
	}

	public void setFormat(String format) {
		this.format = format;
	}

	public String getRecognition() {
		return recognition;
	}

	public void setRecognition(String recognition) {
		this.recognition = recognition;
	}

	
	
}
