package edu.ecompus.weixin.vo.customer;
/**
 * 【客服消息】 视频消息
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-8-30 下午3:55:23
 */
public class WxCustomerVideoMsg extends WxCustomerMsg implements WxCustomer {

	/**
	 * 发送的视频的媒体ID
	 */
	private String mediaId;
	/**
	 * 缩略图的媒体ID
	 */
	private String thumbMediaId;
	/**
	 * 视频消息的标题
	 */
	private String title;
	/**
	 * 视频消息的描述
	 */
	private String description; 
	
	public WxCustomerVideoMsg(String touser, String mediaId, String thumbMediaId, String title, String description) {
		super(touser, "video");
		this.mediaId = mediaId;
		this.thumbMediaId = thumbMediaId;
		this.title = title;
		this.description = description;
	}
	
	public String getJson(){
		String base = super.getJson();
		
		StringBuilder data = new StringBuilder("\"media_id\":\"").append(mediaId).append("\"");
		data.append(",\"thumb_media_id\":\"").append(thumbMediaId).append("\"");
		data.append(",\"title\":\"").append(title).append("\"");
		data.append(",\"description\":\"").append(description).append("\"");
		
		base = base.replaceAll("##data##", data.toString());
		return base;
		
	}

	public String getMediaId() {
		return mediaId;
	}

	public void setMediaId(String mediaId) {
		this.mediaId = mediaId;
	}

	public String getThumbMediaId() {
		return thumbMediaId;
	}

	public void setThumbMediaId(String thumbMediaId) {
		this.thumbMediaId = thumbMediaId;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}
	
	

}
