package edu.ecompus.weixin.vo.customer;

import java.util.List;

import edu.ecompus.weixin.vo.send.WxSendNewsMsgItem;

/**
 * 【客服消息】图文消息
 * 
 * <li>图文消息条数限制在10条以内，注意，如果图文数超过10，则将会无响应。
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-8-30 下午4:13:14
 */
public class WxCustomerNewsMsg extends WxCustomerMsg implements WxCustomer {

	/**
	 * 图文消息列表
	 */
	List<WxSendNewsMsgItem> articles;
	
	public WxCustomerNewsMsg(String touser, List<WxSendNewsMsgItem> articles) {
		super(touser, "news");
		this.articles = articles;
	}
	
	public String getJson(){
		String base = super.getJson();
		
		StringBuilder items = new StringBuilder("");
		//
		if(articles!=null && articles.size()>0){
			//若列表超过10条，取前10条，不足10条取全
			int index = articles.size()>10?10:articles.size();
			
			for(int i=0; i<10; i++){
				WxSendNewsMsgItem item = articles.get(i);
				items.append("{");
				items.append(",\"title\":\"").append(item.getTitle()).append("\"");
				items.append(",\"description\":\"").append(item.getDescription()).append("\"");
				items.append(",\"url\":\"").append(item.getUrl()).append("\"");
				items.append(",\"picurl\":\"").append(item.getPicUrl()).append("\"");
				items.append("},");
				if(index>i) break;
			}
			//删除最后的逗号
			if(items.lastIndexOf(",", items.length())>=0){
				items.deleteCharAt(items.length()-1);
			}
		}
		//内容
		String data = String.format("\"articles\":[%s]", items.toString());
		//提交内容
		base = base.replaceAll("##data##", data);
		return base;
		
	}

	public List<WxSendNewsMsgItem> getArticles() {
		return articles;
	}

	public void setArticles(List<WxSendNewsMsgItem> articles) {
		this.articles = articles;
	}
	
	

}
