package edu.ecompus.weixin.vo.customer;


/**
 * 客服消息共同消息体
 * 
 * <p>当用户主动发消息给公众号的时候（包括发送信息、点击自定义菜单、订阅事件、扫描二维码事件、支付成功事件、用户维权），微信将会把消息数据推送给开发者，开发者在一段时间内（目前修改为48小时）可以调用客服消息接口，通过POST一个JSON数据包来发送消息给普通用户，在48小时内不限制发送次数。此接口主要用于客服等有人工消息处理环节的功能，方便开发者为用户提供更加优质的服务。</p>
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-8-30 下午2:55:25
 */
public class WxCustomerMsg{
	/**
	 * 普通用户openid
	 */
	private String touser;
	/**
	 * 文本消息:text、图片消息:image、语音消息:voice、视频消息:video、音乐消息:music、图文消息:news
	 */
	private String msgtype;
	
	public WxCustomerMsg(String touser,String msgtype) {
		this.touser = touser;
		this.msgtype = msgtype;
	}
	


	public String getTouser() {
		return touser;
	}

	public void setTouser(String touser) {
		this.touser = touser;
	}

	public String getMsgtype() {
		return msgtype;
	}

	public void setMsgtype(String msgtype) {
		this.msgtype = msgtype;
	}

	/**
	 * 生成基础消息内容，##data##为覆盖体
	 * @return
	 */
	public String getJson() {
		StringBuilder data = new StringBuilder("{\"touser\":\"").append(touser).append("\"");
		data.append(",\"msgtype\":\"").append(msgtype).append("\"");
		data.append(",\"").append(msgtype).append("\":\"{##data##}\"");
		data.append("}");
		return data.toString();
	}
	
	
}
