package edu.ecompus.weixin.vo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import net.sf.json.JSONObject;

/**
 * 关注者列表
 * <p>公众号可通过本接口来获取帐号的关注者列表，关注者列表由一串OpenID（加密后的微信号，每个用户对每个公众号的OpenID是唯一的）组成。一次拉取调用最多拉取10000个关注者的OpenID，可以通过多次拉取的方式来满足需求。
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-9-2 下午3:58:43
 */
public class UserPageList implements Serializable {
	private static final long serialVersionUID = 5793622047972685717L;
	/**
	 * 关注该公众账号的总用户数
	 */
	private int total;
	/**
	 * 拉取的OPENID个数，最大值为10000
	 */
	private int count;
	/**
	 * 列表数据，OPENID的列表
	 */
	private List<String> data;
	/**
	 * 拉取列表的后一个用户的OPENID
	 */
	private String next_openid;
	
	public UserPageList(JSONObject json){
		if(json!=null && json.get("total")!=null){
			this.total = json.getInt("total");
			this.count = json.getInt("count");
			this.next_openid  = json.getString("next_openid");
			if(json.getJSONArray("data")!=null){
				data = new ArrayList<String>();
				for(Object obj : json.getJSONArray("data")){
					String openId = String.valueOf(obj);
					if(openId!=null && !"".equals(openId)){
						data.add(openId);
					}
				}
			}
		}
	}

	public int getTotal() {
		return total;
	}

	public void setTotal(int total) {
		this.total = total;
	}

	public int getCount() {
		return count;
	}

	public void setCount(int count) {
		this.count = count;
	}

	public List<String> getData() {
		return data;
	}

	public void setData(List<String> data) {
		this.data = data;
	}

	public String getNext_openid() {
		return next_openid;
	}

	public void setNext_openid(String next_openid) {
		this.next_openid = next_openid;
	}
	
	
	
}
