package edu.ecompus.weixin.vo;

import java.io.Serializable;

import net.sf.json.JSONObject;

/**
 * 用户基本信息(UnionID机制)
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-9-2 下午2:51:48
 */
public class UserItem implements Serializable {
	private static final long serialVersionUID = -83241898408507242L;
	/**
	 * 用户是否订阅该公众号标识，值为0时，代表此用户没有关注该公众号，拉取不到其余信息。
	 */
	private int subscribe;
	/**
	 * 用户的标识，对当前公众号唯一
	 */
	private String openid;
	/**
	 * 用户的昵称
	 */
	private String nickname;
	
	/**
	 * 用户的性别，值为1时是男性，值为2时是女性，值为0时是未知
	 */
	private int sex = 0;
	
	/**
	 * 用户所在城市
	 */
	private String city;
	
	/**
	 * 用户所在国家
	 */
	private String country;
	
	/**
	 * 用户所在省份
	 */
	private String province;
	
	/**
	 * 用户的语言，简体中文为zh_CN
	 */
	private String language;
	
	/**
	 * 用户头像，最后一个数值代表正方形头像大小（有0、46、64、96、132数值可选，0代表640*640正方形头像），用户没有头像时该项为空
	 */
	private String headimgurl;
	
	/**
	 * 用户关注时间，为时间戳。如果用户曾多次关注，则取最后关注时间
	 */
	private String subscribe_time;
	
	/**
	 * 只有在用户将公众号绑定到微信开放平台帐号后，才会出现该字段。详见：获取用户个人信息（UnionID机制）
	 */
	private String unionid;
	
	public UserItem(){
		
	}
	
	public UserItem(String json){
		this(JSONObject.fromObject(json));
	}
	
	public UserItem(JSONObject object){
		if(object!=null){
			if(object.get("subscribe")!=null) this.subscribe = object.getInt("subscribe");
			if(object.get("openid")!=null) this.openid=object.getString("openid");
			if(object.get("nickname")!=null) this.nickname = object.getString("nickname");
			if(object.get("sex")!=null) this.sex = object.getInt("sex");
			if(object.get("city")!=null) this.city = object.getString("city");
			if(object.get("country")!=null) this.country = object.getString("country");
			if(object.get("province")!=null) this.province = object.getString("province");
			if(object.get("language")!=null) this.language = object.getString("language");
			if(object.get("headimgurl")!=null) this.headimgurl = object.getString("headimgurl");
			if(object.get("subscribe_time")!=null) this.subscribe_time = object.getString("subscribe_time");
			if(object.get("unionid")!=null) this.unionid = object.getString("unionid");
		}
	}

	public int getSubscribe() {
		return subscribe;
	}

	public void setSubscribe(int subscribe) {
		this.subscribe = subscribe;
	}

	public String getOpenid() {
		return openid;
	}

	public void setOpenid(String openid) {
		this.openid = openid;
	}

	public String getNickname() {
		return nickname;
	}

	public void setNickname(String nickname) {
		this.nickname = nickname;
	}

	public int getSex() {
		return sex;
	}

	public void setSex(int sex) {
		this.sex = sex;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getCountry() {
		return country;
	}

	public void setCountry(String country) {
		this.country = country;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getLanguage() {
		return language;
	}

	public void setLanguage(String language) {
		this.language = language;
	}

	public String getHeadimgurl() {
		return headimgurl;
	}

	public void setHeadimgurl(String headimgurl) {
		this.headimgurl = headimgurl;
	}

	public String getSubscribe_time() {
		return subscribe_time;
	}

	public void setSubscribe_time(String subscribe_time) {
		this.subscribe_time = subscribe_time;
	}

	public String getUnionid() {
		return unionid;
	}

	public void setUnionid(String unionid) {
		this.unionid = unionid;
	}
	
	
	
}
