package edu.ecompus.weixin.parser;

import org.jdom.Element;
import org.jdom.JDOMException;

import edu.ecompus.weixin.vo.recv.WxRecvMsg;
import edu.ecompus.weixin.vo.recv.WxVoiceRecognitionMsg;
/**
 * WxVoiceRecognitionMsg解析器
 * 
 * <MediaId><![CDATA[media_id]]></MediaId>
 * <Format><![CDATA[Format]]></Format>
 * <Recognition><![CDATA[腾讯微信团队]]></Recognition>
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-8-30 下午2:31:41
 */
public class WxRecvVoiceRecognitionMsgParser extends WxRecvMsgBaseParser {

	@Override
	protected WxVoiceRecognitionMsg parser(Element root, WxRecvMsg msg)
			throws JDOMException {
		return new WxVoiceRecognitionMsg(msg, getElementText(root, "MediaId"), getElementText(root, "Format"), getElementText(root, "Recognition"));
	}

}
