package edu.ecompus.weixin;

import net.sf.json.JSONObject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import edu.ecompus.weixin.vo.UserItem;
import edu.ecompus.weixin.vo.UserPageList;
import edu.ecompus.weixin.vo.WxReturnJson;

/**
 * 微信用户管理
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-9-2 下午3:45:42
 */
public class WeiXinUserUtil {
	/**日志**/
	static Logger log = LoggerFactory.getLogger(WeiXinUserUtil.class);
	
	/**
	 * 获取用户基本信息（包括UnionID机制）
	 * @param openId	普通用户的标识，对当前公众号唯一	
	 * @param token		调用接口凭证
	 * @param lang		返回国家地区语言版本，zh_CN 简体，zh_TW 繁体，en 英语
	 * @return
	 */
	public static UserItem getUserByOpenId(String openId, String token, String lang) {
		//https://api.weixin.qq.com/cgi-bin/user/info?access_token=ACCESS_TOKEN&openid=OPENID&lang=zh_CN
		String url = String.format("https://api.weixin.qq.com/cgi-bin/user/info?access_token=%s&openid=%s&lang=%s", token,openId,lang);
		JSONObject json = WeiXin.get(url, "");
		log.info("获取用户基本信息："+ json.toString());
		if(json!=null && json.get("subscribe")!=null){
			return new UserItem(json);
		}
		
		
		return null;
	}
	
	/**
	 * 设置备注名
	 * @param openId		用户标识
	 * @param remark		新的备注名，长度必须小于30字符
	 * @param token			调用接口凭证
	 * @return
	 */
	public static WxReturnJson editUserRemark(String openId, String remark, String token){
		//https://api.weixin.qq.com/cgi-bin/user/info/updateremark?access_token=ACCESS_TOKEN
		//{"openid":"oDF3iY9ffA-hqb2vVvbr7qxf6A0Q",	"remark":"pangzi"	}
		String url = String.format("https://api.weixin.qq.com/cgi-bin/user/info/updateremark?access_token=%s", token);
		StringBuilder data = new StringBuilder("{\"openid\":\"").append(openId).append(",\"remark\":\"").append(remark).append("\"}");
		JSONObject json = WeiXin.send(url, data.toString());
		log.info("设置备注名："+ json.toString());
		if(json!=null && json.get("errcode")!=null){
			WxReturnJson result = new WxReturnJson(json);
			result.setErrcode(json.getString("errcode"));
			result.setErrmsg(json.getString("errmsg"));
			return result;
		}
		
		return null;
	}
	
	/**
	 * 获取关注者列表
	 * @param nextOpenid
	 * @param token
	 * @return
	 */
	public static UserPageList getUsers(String nextOpenid, String token){
		//https://api.weixin.qq.com/cgi-bin/user/get?access_token=ACCESS_TOKEN&next_openid=NEXT_OPENID
		String url = String.format("https://api.weixin.qq.com/cgi-bin/user/get?access_token=%s&next_openid=%s", token, nextOpenid);
		JSONObject json = WeiXin.get(url, "");
		log.info("获取关注者列表："+ json.toString());
		if(json!=null && json.get("total")!=null){
			return new UserPageList(json);
		}
		
		return null;
	}
}
