package edu.ecompus.weixin;

/**
 * 微信三方登录
 * <li>1. 第三方发起微信授权登录请求，微信用户允许授权第三方应用后，微信会拉起应用或重定向到第三方网站，并且带上授权临时票据code参数；
 * <li>2. 通过code参数加上AppID和AppSecret等，通过API换取access_token；
 * <li>3. 通过access_token进行接口调用，获取用户基本数据资源或帮助用户实现基本操作。
 * 
 * Project:               E-COMPUS WEIXIN-SDK
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.7> 
 * @CopyRight CopyRright (c) 2015
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2015-6-23 上午11:12:05
 */
public class WeiXinQrconnect {
	
	//https://open.weixin.qq.com/connect/qrconnect?appid=APPID&redirect_uri=REDIRECT_URI&response_type=code&scope=SCOPE&state=STATE#wechat_redirect
	/**
	 * 微信三方登录连接地址
	 * <li>1.appid
	 * <li>2.redirect_uri
	 * <li>3.state
	 */
	private final static String QRCONNECT_URL = "https://open.weixin.qq.com/connect/qrconnect?appid=%s&redirect_uri=%s&response_type=code&scope=snsapi_login&state=%s#wechat_redirect";
	
	/**
	 * 生成三方登录连接地址URL
	 * @param appid
	 * @param redirecturi
	 * @param state
	 * @return
	 */
	public static String getQrconnectUrl(String appid, String redirecturi, String state){
		if(appid==null) appid="";
		if(redirecturi==null) return null;
		if(state==null) state="";
		
		return String.format(QRCONNECT_URL, appid, redirecturi, state);
	}
	
}
