package edu.ecompus.weixin;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.List;


import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;

import edu.ecompus.weixin.vo.WxReturnJson;
import edu.ecompus.weixin.vo.media.ArticleItem;

/**
 * 微信多媒体接口
 * <li>上传多媒体文件【基础接口】
 * <li>上传图文消息素材【高级群发接口】
 * <li>
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-9-1 下午4:13:27
 */
public class WeiXinMediaUtil {

	/**
	 * 上传多媒体文件
	 * <p>公众号可调用本接口来上传图片、语音、视频等文件到微信服务器，上传后服务器会返回对应的media_id，公众号此后可根据该media_id来获取多媒体。请注意，media_id是可复用的，调用该接口需http协议。
	 * <li>图片（image）: 1M，支持JPG格式
	 * <li>语音（voice）：2M，播放长度不超过60s，支持AMR\MP3格式
	 * <li>视频（video）：10MB，支持MP4格式
	 * <li>缩略图（thumb）：64KB，支持JPG格式
	 * @param f
	 * @param token	调用接口凭证
	 * @param type 媒体文件类型，分别有图片（image）、语音（voice）、视频（video）和缩略图（thumb）
	 * @return
	 */
	public static WxReturnJson sendFile(File f, String token, String type)  throws Exception{
		//http://file.api.weixin.qq.com/cgi-bin/media/upload?access_token=ACCESS_TOKEN&type=TYPE
		String url = String.format(WeiXinApiGlobal.MEDIA_UPLOAD_URL, token,type) ;
		
		PostMethod filePost = new PostMethod(url); 
		//form-data中媒体文件标识，有filename、filelength、content-type等信息
		Part[] parts = { new FilePart("filename", f) };
		
		filePost.setRequestEntity(new MultipartRequestEntity(parts, filePost.getParams())); 
		HttpClient clients = new HttpClient();
		int status = clients.executeMethod(filePost);
		BufferedReader rd = new BufferedReader(new InputStreamReader(  filePost.getResponseBodyAsStream(), "UTF-8"));
	    StringBuffer stringBuffer = new StringBuffer();
	    String line;
	    while ((line = rd.readLine()) != null) {
	          stringBuffer.append(line);   
	    }   
	    rd.close();
		System.out.println("接受到的流是：" + stringBuffer + "—-" + status);
		//{"type":"TYPE","media_id":"MEDIA_ID","created_at":123456789}
		return new WxReturnJson(stringBuffer.toString());
	}
	
	/**
	 * 上传单、多图文素材
	 * @param articles
	 * @return
	 */
	public static WxReturnJson uploadNews(String token, List<ArticleItem> articles){
		if(articles==null) return null;
		
		StringBuilder data = new StringBuilder("\"articles\":[");
		for(ArticleItem ai : articles){
			data.append(ai.toJson()).append(",");
		}
		
		//删除最后的逗号
		if(data.lastIndexOf(",", data.length())>=0){
			data.deleteCharAt(data.length()-1);
		}
		
		data.append("]");
		//
		String url = String.format(WeiXinApiGlobal.UPLOADNEWS_URL, token) ;
		//发送，并返回生成结果
		return new WxReturnJson(WeiXin.send(url, data.toString()));
	}
	
}
