package edu.ecompus.weixin;

import java.util.ArrayList;
import java.util.List;

import net.sf.json.JSONObject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import edu.ecompus.weixin.vo.WxReturnJson;
import edu.ecompus.weixin.vo.groups.GroupItem;
/**
 * 分组管理接口
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-9-2 下午2:10:35
 */
public class WeiXinGroupUtil {
	/**日志**/
	static Logger log = LoggerFactory.getLogger(WeiXinGroupUtil.class);
	/**
	 * 创建分组
	 * @param groupname	分组名字（30个字符以内）
	 * @param token		访问Token
	 * @return 分组编号
	 */
	public static int create(String groupname, String token) {
		String url = String.format("https://api.weixin.qq.com/cgi-bin/groups/create?access_token=%s", token);
		StringBuilder data = new StringBuilder("{\"name\":\"").append(groupname).append("\"}");
		
		JSONObject json = WeiXin.send(url, data.toString());
		log.info("创建分组结果："+ json.toString());
		if(json!=null && json.get("id")!=null){
			return json.getInt("id");
		}
		return  0;
	}
	
	/**
	 * 查询所有分组
	 * @param token		访问Token
	 * @return
	 */
	public static List<GroupItem> getGroups(String token){
		String url = String.format("https://api.weixin.qq.com/cgi-bin/groups/get?access_token=%s", token);
		
		List<GroupItem> list = new ArrayList<GroupItem>();
		JSONObject json = WeiXin.send(url, "");
		log.info("查询所有分组："+ json.toString());
		if(json!=null && json.get("groups")!=null){
			for(Object obj : json.getJSONArray("groups")){
				JSONObject item = JSONObject.fromObject(obj);
				if(item!=null && item.get("id")!=null){
					GroupItem gi = new GroupItem(item);
					list.add(gi);
				}
			}
		}
		
		
		return list;
	}
	
	/**
	 * 根据用户OpenId查询分组编号（查询用户所在分组）
	 * @param openId		
	 * @param token
	 * @return
	 */
	public static int getGroupIdByOpenId(String openId, String token){
		String url = String.format("https://api.weixin.qq.com/cgi-bin/groups/getid?access_token=%s", token);
		//https://api.weixin.qq.com/cgi-bin/groups/getid?access_token=ACCESS_TOKEN
		StringBuilder data = new StringBuilder("{\"openid\":\"").append(openId).append("\"}");
		
		JSONObject json = WeiXin.send(url, data.toString());
		log.info("查询用户所在分组："+ json.toString());
		
		if(json!=null && json.get("groupid")!=null){
			return json.getInt("groupid");
		}
		
		return 0;
	}
	
	/**
	 * 修改分组名
	 * @param groupId		分组编号
	 * @param groupname		新名称
	 * @param token			访问token
	 * @return
	 */
	public static WxReturnJson editGroup(int groupId, String groupname, String token ){
		//https://api.weixin.qq.com/cgi-bin/groups/update?access_token=ACCESS_TOKEN
		//{"group":{"id":108,"name":"test2_modify2"}}
		String url = String.format("https://api.weixin.qq.com/cgi-bin/groups/update?access_token=%s", token);
		StringBuilder data = new StringBuilder("{\"group\":{\"id\":").append(groupId).append(",\"name\":\"").append(groupname).append("\"}}");
		
		JSONObject json = WeiXin.send(url, data.toString());
		log.info("修改分组名："+ json.toString());
		
		if(json!=null && json.get("errcode")!=null){
			WxReturnJson result = new WxReturnJson(json);
			return result;
		}
		
		
		return null;
	}
	
	/**
	 * 移动用户分组
	 * @param groupId		分组编号
	 * @param openId		用户OpenId
	 * @param token			访问Token
	 * @return
	 */
	public static WxReturnJson editUserGroup(int groupId,String openId, String token){
		//"openid":"oDF3iYx0ro3_7jD4HFRDfrjdCM58","to_groupid":108
		//https://api.weixin.qq.com/cgi-bin/groups/members/update?access_token=ACCESS_TOKEN
		String url = String.format("https://api.weixin.qq.com/cgi-bin/groups/members/update?access_token=%s", token);
		StringBuilder data = new StringBuilder("{\"openid\":\"").append(openId).append(",\"to_groupid\":\"").append(groupId).append("\"}");
		JSONObject json = WeiXin.send(url, data.toString());
		log.info("移动用户分组："+ json.toString());
		if(json!=null && json.get("errcode")!=null){
			WxReturnJson result = new WxReturnJson(json);
			return result;
		}
		
		return null;
	}
	
}
