package edu.ecompus.weixin;

import java.util.List;

import net.sf.json.JSONObject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import edu.ecompus.weixin.vo.customer.WxCustomerImageMsg;
import edu.ecompus.weixin.vo.customer.WxCustomerMusicMsg;
import edu.ecompus.weixin.vo.customer.WxCustomerNewsMsg;
import edu.ecompus.weixin.vo.customer.WxCustomerTextMsg;
import edu.ecompus.weixin.vo.customer.WxCustomerVideoMsg;
import edu.ecompus.weixin.vo.customer.WxCustomerVoiceMsg;
import edu.ecompus.weixin.vo.send.WxSendNewsMsgItem;

/**
 * 发送客服消息 类
 * 
 * <p>当用户主动发消息给公众号的时候（包括发送信息、点击自定义菜单、订阅事件、扫描二维码事件、支付成功事件、用户维权），微信将会把消息数据推送给开发者，开发者在一段时间内（目前修改为48小时）可以调用客服消息接口，通过POST一个JSON数据包来发送消息给普通用户，在48小时内不限制发送次数。此接口主要用于客服等有人工消息处理环节的功能，方便开发者为用户提供更加优质的服务。
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-8-30 下午3:24:27
 */
public class WeiXinCustomerUtil {
	/**日志**/
	private static Logger log = LoggerFactory.getLogger(WeiXinCustomerUtil.class);
	
	static String baseUrl = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=";
			
	/**
	 *  发送文本消息
	 * @param touser		普通用户openid
	 * @param text			文本内容
	 * @param token			访问Token
	 * @return
	 */
	public static JSONObject sendText(String touser, String text, String token) {
		log.info("【客服消息】发送文本消息");
		String url = baseUrl + token;
		//生成文本消息
		WxCustomerTextMsg txt = new WxCustomerTextMsg(touser, text);
		
		return WeiXin.send(url, txt.getJson());
	}
	
	/**
	 *  发送图片消息
	 * @param touser		普通用户openid
	 * @param mediaId		发送的图片的媒体ID
	 * @param token			访问Token
	 * @return
	 */
	public static JSONObject sendImage(String touser, String mediaId, String token) {
		log.info("【客服消息】发送图片消息");
		String url = baseUrl + token;
		//生成文本消息
		WxCustomerImageMsg img = new WxCustomerImageMsg(touser, mediaId);
		
		return WeiXin.send(url, img.getJson());
	}
	
	/**
	 *  发送语音消息
	 * @param touser		普通用户openid
	 * @param mediaId		发送的语音的媒体ID
	 * @param token			访问Token
	 * @return
	 */
	public static JSONObject sendVoice(String touser, String mediaId, String token) {
		log.info("【客服消息】发送语音消息");
		String url = baseUrl + token;
		//生成文本消息
		WxCustomerVoiceMsg voice = new WxCustomerVoiceMsg(touser, mediaId);
		
		return WeiXin.send(url, voice.getJson());
	}
	
	/**
	 * 发送视频消息
	 * @param touser		普通用户openid
	 * @param mediaId		发送的视频的媒体ID
	 * @param thumbMediaId	缩略图的媒体ID
	 * @param title			视频消息的标题
	 * @param description	视频消息的描述
	 * @param token			访问Token
	 * @return
	 */
	public static JSONObject sendVideo(String touser, String mediaId, String thumbMediaId, String title, String description, String token) {
		log.info("【客服消息】发送视频消息");
		String url = baseUrl + token;
		//生成文本消息
		WxCustomerVideoMsg video = new WxCustomerVideoMsg(token,mediaId,thumbMediaId,title,description);
		
		return WeiXin.send(url, video.getJson());
	}
	
	/**
	 * 发送音频消息
	 * @param touser			普通用户openid
	 * @param title				音乐标题
	 * @param description		音乐描述
	 * @param musicurl			音乐链接
	 * @param hqmusicurl		高品质音乐链接，wifi环境优先使用该链接播放音乐
	 * @param thumbMediaId		缩略图的媒体ID
	 * @param token				访问Token
	 * @return
	 */
	public static JSONObject sendMusic(String touser, String title, String description, String musicurl, String hqmusicurl, String thumbMediaId, String token) {
		log.info("【客服消息】发送音频消息");
		String url = baseUrl + token;
		//生成文本消息
		WxCustomerMusicMsg music = new WxCustomerMusicMsg(token,title, description, musicurl, hqmusicurl, thumbMediaId);
		
		return WeiXin.send(url, music.getJson());
	}
	
	/**
	 * 发送图文消息	
	 * @param touser		普通用户openid
	 * @param articles		图文列表
	 * @param token			访问Token
	 * @return
	 */
	public static JSONObject sendNews(String touser, List<WxSendNewsMsgItem> articles, String token) {
		log.info("【客服消息】发送图文消息");
		String url = baseUrl + token;
		
		WxCustomerNewsMsg news = new WxCustomerNewsMsg(touser, articles);
		
		return WeiXin.send(url, news.getJson());
	}
	
	
}
