package edu.ecompus.weixin;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * SHA1/MD5   微信公众平台加密工具类
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-9-30 上午9:52:31
 */
public final class HashKitUtil {
	private static final char[] LETTERS = "0123456789ABCDEF".toCharArray();
	
	/**
	 * md5加密
	 * @param value
	 * @return
	 */
	public static String md5(String value) {
		try {
			return hash(MessageDigest.getInstance("md5"), value);
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	/**
	 * sha1加密
	 * @param value
	 * @return
	 */
	public static String sha1(String value) {
		try {
			return hash(MessageDigest.getInstance("SHA1"), value);
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	
	private static String hash(MessageDigest digest,String src) {
		return toHexString(digest.digest(src.getBytes()));
	}
	
	private static String toHexString(byte[] bytes) {
		char[] values = new char[bytes.length * 2];
		int i=0;
		for(byte b : bytes) {
			values[i++] = LETTERS[((b & 0xF0) >>> 4)];
			values[i++] = LETTERS[b & 0xF];
		}
		return String.valueOf(values);
	}
	
	
}
