/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.weixin;

import edu.ecompus.weixin.WeiXin;
import edu.ecompus.weixin.vo.WxReturnJson;
import edu.ecompus.weixin.vo.groups.GroupItem;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeiXinGroupUtil {
    static Logger log = LoggerFactory.getLogger(WeiXinGroupUtil.class);

    public static int create(String groupname, String token) {
        String url = String.format("https://api.weixin.qq.com/cgi-bin/groups/create?access_token=%s", token);
        StringBuilder data = new StringBuilder("{\"name\":\"").append(groupname).append("\"}");
        JSONObject json = WeiXin.send(url, data.toString());
        log.info("\u521b\u5efa\u5206\u7ec4\u7ed3\u679c\uff1a" + json.toString());
        if (json != null && json.get("id") != null) {
            return json.getInt("id");
        }
        return 0;
    }

    public static List<GroupItem> getGroups(String token) {
        String url = String.format("https://api.weixin.qq.com/cgi-bin/groups/get?access_token=%s", token);
        ArrayList<GroupItem> list = new ArrayList<GroupItem>();
        JSONObject json = WeiXin.send(url, "");
        log.info("\u67e5\u8be2\u6240\u6709\u5206\u7ec4\uff1a" + json.toString());
        if (json != null && json.get("groups") != null) {
            for (Object obj : json.getJSONArray("groups")) {
                JSONObject item = JSONObject.fromObject(obj);
                if (item == null || item.get("id") == null) continue;
                GroupItem gi = new GroupItem(item);
                list.add(gi);
            }
        }
        return list;
    }

    public static int getGroupIdByOpenId(String openId, String token) {
        String url = String.format("https://api.weixin.qq.com/cgi-bin/groups/getid?access_token=%s", token);
        StringBuilder data = new StringBuilder("{\"openid\":\"").append(openId).append("\"}");
        JSONObject json = WeiXin.send(url, data.toString());
        log.info("\u67e5\u8be2\u7528\u6237\u6240\u5728\u5206\u7ec4\uff1a" + json.toString());
        if (json != null && json.get("groupid") != null) {
            return json.getInt("groupid");
        }
        return 0;
    }

    public static WxReturnJson editGroup(int groupId, String groupname, String token) {
        String url = String.format("https://api.weixin.qq.com/cgi-bin/groups/update?access_token=%s", token);
        StringBuilder data = new StringBuilder("{\"group\":{\"id\":").append(groupId).append(",\"name\":\"").append(groupname).append("\"}}");
        JSONObject json = WeiXin.send(url, data.toString());
        log.info("\u4fee\u6539\u5206\u7ec4\u540d\uff1a" + json.toString());
        if (json != null && json.get("errcode") != null) {
            WxReturnJson result = new WxReturnJson(json);
            return result;
        }
        return null;
    }

    public static WxReturnJson editUserGroup(int groupId, String openId, String token) {
        String url = String.format("https://api.weixin.qq.com/cgi-bin/groups/members/update?access_token=%s", token);
        StringBuilder data = new StringBuilder("{\"openid\":\"").append(openId).append(",\"to_groupid\":\"").append(groupId).append("\"}");
        JSONObject json = WeiXin.send(url, data.toString());
        log.info("\u79fb\u52a8\u7528\u6237\u5206\u7ec4\uff1a" + json.toString());
        if (json != null && json.get("errcode") != null) {
            WxReturnJson result = new WxReturnJson(json);
            return result;
        }
        return null;
    }
}

