/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.weixin;

import edu.ecompus.weixin.WeiXin;
import edu.ecompus.weixin.vo.customer.WxCustomerImageMsg;
import edu.ecompus.weixin.vo.customer.WxCustomerMusicMsg;
import edu.ecompus.weixin.vo.customer.WxCustomerNewsMsg;
import edu.ecompus.weixin.vo.customer.WxCustomerTextMsg;
import edu.ecompus.weixin.vo.customer.WxCustomerVideoMsg;
import edu.ecompus.weixin.vo.customer.WxCustomerVoiceMsg;
import edu.ecompus.weixin.vo.send.WxSendNewsMsgItem;
import java.util.List;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeiXinCustomerUtil {
    private static Logger log = LoggerFactory.getLogger(WeiXinCustomerUtil.class);
    static String baseUrl = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=";

    public static JSONObject sendText(String touser, String text, String token) {
        log.info("\u3010\u5ba2\u670d\u6d88\u606f\u3011\u53d1\u9001\u6587\u672c\u6d88\u606f");
        String url = baseUrl + token;
        WxCustomerTextMsg txt = new WxCustomerTextMsg(touser, text);
        return WeiXin.send(url, txt.getJson());
    }

    public static JSONObject sendImage(String touser, String mediaId, String token) {
        log.info("\u3010\u5ba2\u670d\u6d88\u606f\u3011\u53d1\u9001\u56fe\u7247\u6d88\u606f");
        String url = baseUrl + token;
        WxCustomerImageMsg img = new WxCustomerImageMsg(touser, mediaId);
        return WeiXin.send(url, img.getJson());
    }

    public static JSONObject sendVoice(String touser, String mediaId, String token) {
        log.info("\u3010\u5ba2\u670d\u6d88\u606f\u3011\u53d1\u9001\u8bed\u97f3\u6d88\u606f");
        String url = baseUrl + token;
        WxCustomerVoiceMsg voice = new WxCustomerVoiceMsg(touser, mediaId);
        return WeiXin.send(url, voice.getJson());
    }

    public static JSONObject sendVideo(String touser, String mediaId, String thumbMediaId, String title, String description, String token) {
        log.info("\u3010\u5ba2\u670d\u6d88\u606f\u3011\u53d1\u9001\u89c6\u9891\u6d88\u606f");
        String url = baseUrl + token;
        WxCustomerVideoMsg video = new WxCustomerVideoMsg(token, mediaId, thumbMediaId, title, description);
        return WeiXin.send(url, video.getJson());
    }

    public static JSONObject sendMusic(String touser, String title, String description, String musicurl, String hqmusicurl, String thumbMediaId, String token) {
        log.info("\u3010\u5ba2\u670d\u6d88\u606f\u3011\u53d1\u9001\u97f3\u9891\u6d88\u606f");
        String url = baseUrl + token;
        WxCustomerMusicMsg music = new WxCustomerMusicMsg(token, title, description, musicurl, hqmusicurl, thumbMediaId);
        return WeiXin.send(url, music.getJson());
    }

    public static JSONObject sendNews(String touser, List<WxSendNewsMsgItem> articles, String token) {
        log.info("\u3010\u5ba2\u670d\u6d88\u606f\u3011\u53d1\u9001\u56fe\u6587\u6d88\u606f");
        String url = baseUrl + token;
        WxCustomerNewsMsg news = new WxCustomerNewsMsg(touser, articles);
        return WeiXin.send(url, news.getJson());
    }
}

